'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 22 May 2007 at 7:28:42 am'!
SmartSyntaxInterpreterPlugin subclass: #ClipboardExtendedPlugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VMMaker-Plugins'!

!ClipboardExtendedPlugin methodsFor: 'io' stamp: 'JSM 5/8/2006 23:39'!
ioAddClipboardData: clipboard data: data dataFormat: aFormat
| clipboardAddress formatLength dataLength |
self primitive: 'ioAddClipboardData' parameters: #(Oop ByteArray String).

clipboardAddress := interpreterProxy positive32BitValueOf: clipboard.

dataLength := interpreterProxy slotSizeOf: data cPtrAsOop.
formatLength := interpreterProxy slotSizeOf: aFormat cPtrAsOop.

self sqPasteboardPutItemFlavor: clipboardAddress data: data length: dataLength formatType: aFormat formatLength: formatLength.
! !

!ClipboardExtendedPlugin methodsFor: 'io' stamp: 'JSM 5/6/2006 18:59'!
ioClearClipboard: clipboard
| clipboardAddress |
self primitive: 'ioClearClipboard' parameters: #(Oop).
clipboardAddress :=  interpreterProxy positive32BitValueOf: clipboard.
self sqPasteboardClear: clipboardAddress.! !

!ClipboardExtendedPlugin methodsFor: 'io' stamp: 'JSM 5/6/2006 19:23'!
ioCreateClipboard
| clipboardAddress |
self primitive: 'ioCreateClipboard' parameters: #().

clipboardAddress := interpreterProxy positive32BitIntegerFor: self sqCreateClipboard.

^ clipboardAddress.! !

!ClipboardExtendedPlugin methodsFor: 'io' stamp: 'JSM 5/9/2006 01:39'!
ioGetClipboardFormat: clipboard formatNumber: formatNumber 
	| clipboardAddress itemCount |
	self primitive: 'ioGetClipboardFormat' parameters: #(#Oop #SmallInteger ).
	clipboardAddress := interpreterProxy positive32BitValueOf: clipboard.
	itemCount := self sqPasteboardGetItemCount: clipboardAddress.
	itemCount > 0
		ifTrue: [^ self sqPasteboardCopyItemFlavors: clipboardAddress itemNumber: formatNumber].
	^ interpreterProxy nilObject! !

!ClipboardExtendedPlugin methodsFor: 'io' stamp: 'JSM 5/7/2006 13:07'!
ioReadClipboardData: clipboard format: format
| clipboardAddress formatLength |
self primitive: 'ioReadClipboardData' parameters: #(Oop String).
clipboardAddress := interpreterProxy positive32BitValueOf: clipboard.
formatLength := interpreterProxy slotSizeOf: format cPtrAsOop.
^ self sqPasteboardCopyItemFlavorData: clipboardAddress format: format formatLength: formatLength.
! !

